//+------------------------------------------------------------------+
//|                                              AUDJPYWednseday1500 |
//|                                                 Copyright  2009 |
//|                                                www.EarnForex.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, EarnForex.com"
#property link      "http://www.earnforex.com"
#property version   "1.01"
#property description "Based on Wednesday AUD/JPY Strategy:"
#property description "http://www.earnforex.com/forex-strategy/wednesday-aud-jpy-strategy"
#property description "Trades only on bars' open on 15:00 EST each Wednesday with AUD/JPY pair"

input double Lots = 0.1;
input int Slippage = 5;
input int Server_EST_Difference = 6;

double Poin;
int Deviation;

int LastBars = 0;
bool pos_post = false; //Is position already posted?

int HourToCheck;
int DayToCheck;

void OnInit()
{
	Poin = _Point;
	Deviation = Slippage;
	//Checking for unconvetional Point digits number
   if ((_Point == 0.00001) || (_Point == 0.001))
   {
      Poin *= 10;
      Deviation *= 10;
   }

   if ((15 + Server_EST_Difference) > 23)
   {
      HourToCheck = 15 + Server_EST_Difference - 24;
      DayToCheck = 4;
   }
   else
   {
      HourToCheck = 15 + Server_EST_Difference;
      DayToCheck = 3;
   }
}

//+------------------------------------------------------------------+
//| Checking time and date then posting order or closing position    |
//+------------------------------------------------------------------+
void OnTick()
{
   //Wait for the new Bar in a chart.
	if (LastBars == Bars(_Symbol, _Period)) return;
	else LastBars = Bars(_Symbol, _Period);

   MqlDateTime dt;
   TimeToStruct(TimeCurrent(), dt);
   if ((dt.hour == HourToCheck) && (dt.day_of_week == DayToCheck))
   {
      fSell();
   }
   else if (((dt.hour != HourToCheck) || (dt.day_of_week != DayToCheck)) && (pos_post))
   {
      fClose();
   }
}

//+------------------------------------------------------------------+
//| Sell                                                             |
//+------------------------------------------------------------------+
void fSell()
{
	MqlTradeRequest Request;
	Request.action = TRADE_ACTION_DEAL;
	Request.symbol = _Symbol;
	Request.volume = Lots;
	Request.price = SymbolInfoDouble(Symbol(), SYMBOL_BID);
	Request.type = ORDER_TYPE_SELL; 
   Request.type_filling = ORDER_FILLING_FOK;
   Request.deviation = Deviation;
   Request.comment = "AUD/JPY Wednesday 15:00 EST";
   
   MqlTradeResult Result;
   
	bool result = OrderSend(Request, Result); 
	if (result == false)	Print("Incorrect Request/Result Structure when Buying.");
	else Print("Result Code: ", Result.retcode, ", ", "Deal: ", Result.deal, ", ", "Volume: ", Result.volume, ", ", "Price: ", Result.price, ", ", "Requote Bid: ", Result.bid, ", ", "Requote Ask: ", Result.ask);
	
	pos_post = true;
}

//+------------------------------------------------------------------+
//| Close an order                                                   |
//+------------------------------------------------------------------+
void fClose()
{
	MqlTradeRequest Request;
	Request.action = TRADE_ACTION_DEAL;
	Request.symbol = _Symbol;
	Request.volume = Lots;
	Request.price = SymbolInfoDouble(Symbol(), SYMBOL_ASK);
	Request.type = ORDER_TYPE_BUY; 
   Request.type_filling = ORDER_FILLING_FOK;
   Request.deviation = Deviation;
   Request.comment = "AUD/JPY Wednesday 15:00 EST";
   
   MqlTradeResult Result;
   
	bool result = OrderSend(Request, Result); 
	if (result == false)	Print("Incorrect Request/Result Structure when Selling.");
	else Print("Result Code: ", Result.retcode, ", ", "Deal: ", Result.deal, ", ", "Volume: ", Result.volume, ", ", "Price: ", Result.price, ", ", "Requote Bid: ", Result.bid, ", ", "Requote Ask: ", Result.ask);
	
	pos_post = false;
}