////////////////////////////////////////////////////////////////////
// myfxovereasy.mq4
// ver. 1.0.4
// 2007-20012 http://www.earnforex.com
////////////////////////////////////////////////////////////////////
// Based on combined FXOverEasy indicators. High CPU usage!
// Sometimes high profits can be interrupted with a row of losses.
// Don't trade with more than 2% of your total margin.
////////////////////////////////////////////////////////////////////

#property copyright "EA myfxovereasy www.earnforex.com 2007-2012"

/*
	Parameters are optimized for EUR/USD M15 chart and $1,000 account
*/

extern int TakeProfit = 160;
extern int StopLoss = 110;
extern int MaxPositions = 0; //0 for no limits

extern double Lots=0.1;

extern double Slippage = 3;

extern int ComboTriggerLevel = 6; // Can be 6 or 8

extern bool OnlyTradeFullBars = true;

extern color clOpenBuy = Blue;
extern color clOpenSell = Red;

extern bool MoveStops = false; //Apply "trailing" stop
extern int StopTarget1 = 50; //If profit reaches this target
extern int StopLevel1 = 20; // this stop-level (in pips of profit) is set
extern int StopTarget2 = 90; //If profit reaches this target
extern int StopLevel2 = 40; // this stop-level (in pips of profit) is set
extern int StopTarget3 = 130; //If profit reaches this target
extern int StopLevel3 = 60; //  this stop-level (in pips of profit) is set
extern bool ECN_Mode = false; // In ECN mode, SL and TP aren't applied on OrderSend() but are added later with OrderModify()


int Magic; //EA magic number
int LastBars = 0; //Last number of bars in chart

double Poin;

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
{
	//Checking for unconvetional Point digits number
   if (Point == 0.00001) Poin = 0.0001; //5 digits
   else if (Point == 0.001) Poin = 0.01; //3 digits
   else Poin = Point; //Normal
   Magic = Period()+103605052008;
	return(0);
}
  
//+------------------------------------------------------------------+
//|     Start of the EA Heder                                        |
//+------------------------------------------------------------------+
int start()
{
	int result, lookupidx; //Intermediate variables

   if (MoveStops) AdjustOrders();
	
	if (LastBars == iBars(Symbol(), 0)) return(0); //If no new bars formed since last iteration
	else LastBars = iBars(Symbol(), 0); //Update LastBars

	if ((TakeProfit <= 0) || (StopLoss <= 0)) //Check TakeProfit and StopLoss validity
	{
		Print("TakeProfit and StopLoss should be greater than 0.");
		return(0);
	}
	
	if(AccountFreeMargin()<(1000*Lots)) //Check free margin
	{
		Print("We have no money. Free Margin = ", AccountFreeMargin());
		return(0);  
	}

	if (OnlyTradeFullBars)
		if (Volume[0]>1) return(0); //Skip partial bar
		else lookupidx= 1; //Look at the values of the previous bar (recently completed bar)
	else lookupidx= 0;
	
	int graylevel = iCustom(NULL, 0, "FXOE-Combo", 0, lookupidx);
	int redlevel = iCustom(NULL, 0, "FXOE-Combo", 1, lookupidx);
	int greenlevel = iCustom(NULL, 0, "FXOE-Combo", 2, lookupidx);
	
	if (greenlevel != 0) result = greenlevel;
	else if (redlevel != 0) result = redlevel;
	else result = 0;

   if (MaxPositions > 0)
   {
      int count = 0;
      int total = OrdersTotal();
      for (int pos = 0; pos < total; pos++)
      {
        if (OrderSelect(pos, SELECT_BY_POS) == false) continue;
        if ((OrderMagicNumber() == Magic) && (OrderSymbol() == Symbol())) count++;
      }
      if (count >= MaxPositions) return(0);
   }
	
	if (result >= ComboTriggerLevel) fSell();  //Short
	if (result <= -ComboTriggerLevel) fBuy(); //Long
	
	return(0);
}

//+------------------------------------------------------------------+
//| Buy                                                              |
//+------------------------------------------------------------------+
void fBuy()
{
   double SL = 0, TP = 0, ecnSL = 0, ecnTP = 0;
	RefreshRates();

	if (!ECN_Mode)
	{
      if (StopLoss > 0) SL = Ask - StopLoss * Poin;
      if (TakeProfit > 0) TP = Ask + TakeProfit * Poin;
   }
   else
   {
      if (StopLoss > 0) ecnSL = Ask - StopLoss * Poin;
      if (TakeProfit > 0) ecnTP = Ask + TakeProfit * Poin;
   }

	int result = OrderSend(Symbol(),OP_BUY,Lots,Ask,Slippage,SL,TP,"myfxovereasy",Magic,0,clOpenBuy); 

	if (result > 0)
	{
      Print("Long: ", Ask);
      if (ECN_Mode)
      {
         OrderSelect(result, SELECT_BY_TICKET);
         OrderModify(result, OrderOpenPrice(), ecnSL, ecnTP, 0);
      }
   }
}

//+------------------------------------------------------------------+
//| Sell                                                             |
//+------------------------------------------------------------------+
void fSell()
{
   double SL = 0, TP = 0, ecnSL = 0, ecnTP = 0;
	RefreshRates();

	if (!ECN_Mode)
	{
      if (StopLoss > 0) SL = Bid + StopLoss * Poin;
      if (TakeProfit > 0) TP = Bid - TakeProfit * Poin;
   }
   else
   {
      if (StopLoss > 0) ecnSL = Bid + StopLoss * Poin;
      if (TakeProfit > 0) ecnTP = Bid - TakeProfit * Poin;
   }
   
	int result = OrderSend(Symbol(),OP_SELL,Lots,Bid,Slippage,Bid+StopLoss*Poin,Ask-TakeProfit*Poin,"myfxovereasy",Magic,0,clOpenSell); 

	if (result > 0)
	{
      Print("Short: ", Bid);
      if (ECN_Mode)
      {
         OrderSelect(result, SELECT_BY_TICKET);
         OrderModify(result, OrderOpenPrice(), ecnSL, ecnTP, 0);
      }
   }
}

//+------------------------------------------------------------------+
//| Apply "tralining" stop                                           |
//+------------------------------------------------------------------+
void AdjustOrders()
{
   int count = 0;
   int total = OrdersTotal();
   for (int pos = 0; pos < total; pos++)
   {
     if (OrderSelect(pos, SELECT_BY_POS) == false) continue;
     if ((OrderMagicNumber() == Magic) && (OrderSymbol() == Symbol()))
     {
        RefreshRates();
        if ((OrderType() == OP_BUY) && ((Bid - OrderOpenPrice()) >= (StopTarget1 * Poin))) // 1st Level
        {
           if ((Bid - OrderOpenPrice()) >= (StopTarget2 * Poin)) // 2nd Level
           {
              if ((Bid - OrderOpenPrice()) >= (StopTarget3 * Poin)) // 3rd Level
              {
                  RefreshRates();
                  if (OrderStopLoss() < (OrderOpenPrice() + StopLevel3 * Poin))
                     OrderModify(OrderTicket(), OrderOpenPrice(), OrderOpenPrice() + StopLevel3 * Poin, OrderTakeProfit(), 0);
              }
              else
              {
                  RefreshRates();
                  if (OrderStopLoss() < (OrderOpenPrice() + StopLevel2 * Poin))
                     OrderModify(OrderTicket(), OrderOpenPrice(), OrderOpenPrice() + StopLevel2 * Poin, OrderTakeProfit(), 0);
              }
           }
           else
           {
               RefreshRates();
               if (OrderStopLoss() < (OrderOpenPrice() + StopLevel1 * Poin))
                  OrderModify(OrderTicket(), OrderOpenPrice(), OrderOpenPrice() + StopLevel1 * Poin, OrderTakeProfit(), 0);
           }
        }
        else if ((OrderType() == OP_SELL) && ((OrderOpenPrice() - Ask) >= (StopTarget1 * Poin))) // 1st Level
        {
           if ((OrderOpenPrice() - Ask) >= (StopTarget2 * Poin)) // 2nd Level
           {
              if ((OrderOpenPrice() - Ask) >= (StopTarget3 * Poin)) // 3rd Level
              {
                  RefreshRates();
                  if (OrderStopLoss() > (OrderOpenPrice() - StopLevel3 * Poin))
                     OrderModify(OrderTicket(), OrderOpenPrice(), OrderOpenPrice() - StopLevel3 * Poin, OrderTakeProfit(), 0);
              }
              else
              {
                  RefreshRates();
                  if (OrderStopLoss() > (OrderOpenPrice() - StopLevel2 * Poin))
                     OrderModify(OrderTicket(), OrderOpenPrice(), OrderOpenPrice() - StopLevel2 * Poin, OrderTakeProfit(), 0);
              }
           }
           else
           {
               RefreshRates();
               if (OrderStopLoss() > (OrderOpenPrice() - StopLevel1 * Poin))
                  OrderModify(OrderTicket(), OrderOpenPrice(), OrderOpenPrice() - StopLevel1 * Poin, OrderTakeProfit(), 0);
           }
        }
     }
   }
}