
//+------------------------------------------------------------------+
//|                                                                  |
//|  FUNCTION LIBRARY FOR FXOVEREASY INDICATOR SET                   |
//|                                                                  |
//|  By Shimodax (see individual function for original authors)      |
//|                                                                  |
//|                                                                  |
//|  System description and forum:                                   |
//|  - http://fxovereasy.50webs.com/Home.html                        |
//|  - http://www.strategybuilderfx.com/forums/showthread.php?t=15112|
//|                                                                  |
//+------------------------------------------------------------------+
   
 
extern bool DebugLogger= false;
   
   

//+------------------------------------------------------------------+
//| Combo Indicator (All-In-One signal)                              |
//+------------------------------------------------------------------+
int Combo(int offset, int lastbar, double &longsignalbuf[], double &shortsignalbuf[], double &neutralbuffer[], 
         bool useasctrend, double gamma, int lgecho, int juicelevel, int colthreshold)
{
   int asctrend, val, errslope, jval, tval, sval, aval2, 
          lvalidx= 0, lval= 0, avalidx= 0, aval= 0; // lval/aval must be defined outside the loop(!)
   double juice, trend, slope, lrsi, lrsi2,
          dummy1[100], dummy2[100], dummy3[100], dummy4[100], dummy5[100], dummy6[100],   // we're not really interested in all the data from the sub-indies
          result;
   
   
   if (lastbar>Bars)
      lastbar= Bars;
      
   lvalidx= 0;
   lval= 0;
   
   avalidx= 0;
   aval= 0;
   
   
        
   for (int i= lastbar+lgecho+1; i>=offset; i--) {

      juice= Juice(i, i+10, dummy1, dummy2, 7, juicelevel);
      trend= ITrend(i, i+10, dummy1, dummy2, dummy3, dummy4, 20, 2, 13);
      errslope= SHIChannels(i, 240, dummy1, dummy2, dummy3, dummy4, dummy5, dummy6, result, 0, false);
      lrsi= LaguerreRSI(i, i+1, dummy1, gamma);
      lrsi2= LaguerreRSI(i+1, i+1, dummy1, gamma);
      
      if (useasctrend)
         asctrend= AscTrend(i, i+200, dummy1, dummy1, 4);
      else 
         asctrend= 0;
   
      if (!errslope) 
         slope= result;
      else 
         slope= 0;
 
      jval= 0; 
      tval= 0;
      sval= 0;
      // aval= 0; do not reset, persists over iterations
      // lval= 0; do not reset, persists over iterations


      // juice okay?          
      if (juice>=0) 
         jval= 2;       // JUICY ENOUGH
      else
         jval= 1;         


      // slope direction?
      if (slope>0)      // LONG 
         sval= 1;
      else 
      if (trend<0)      // SHORT
         sval= -1;
      
      
      // itrend direction?
      if (trend>0)      // LONG 
         tval= 1;
      else 
      if (trend<0)      // SHORT_VALUE
         tval= -1;


      // asctrend signal?  ( +1/-1 means inside long/short trend, +2/-2 means signal for long/short
      if (asctrend>=2) {  // LONG 
         aval= 1;
         avalidx= i;
      }
      else 
      if (asctrend<=-2) {      // SHORT_VALUE
         aval= -1;
         avalidx= i;
      }


      // laguerre crossing on this bar
      if (lrsi2<0.15 && lrsi>=0.15) {
         lval= 1;
         lvalidx= i;
      }
      else
      if (lrsi2>0.75 && lrsi<=0.75) {
         lval= -1;
         lvalidx= i;
      }


      // check expiration of lrsi (max "2" bars)
      if (aval!=0 && (avalidx-i)>1)
         aval= 0;
      

      // check expiration of lrsi (max "lgecho" bars)
      if (lval!=0 && (lvalidx-i)>lgecho)
         lval= 0;

     
      val= jval * (sval + tval + lval);

      // asctrend signal only counts if others is there
      if (MathAbs(val)>=6) 
         val+= aval * jval;   
      
      if (DebugLogger)
         Print(TimeToStr(Time[i]), " #", i, " juice ", juice, ", itrend ", trend, ", slope ", slope, ", lrsi ", lrsi, ", jval ", jval, " * (tval ", tval, " + sval ", sval, " + aval ", aval, "/", aval2, " + lval ", lval, ") => ", val);
      
      
      if (i<=lastbar) {    // ignore the first few loops that were only used to catch previous lrsi signals
         longsignalbuf[i]= 0;
         shortsignalbuf[i]= 0;
         neutralbuffer[i]= 0;

         if (val>=colthreshold)
            longsignalbuf[i]= val;
         else
         if (val<=-colthreshold)
            shortsignalbuf[i]= val;
         else
            neutralbuffer[i]= val;
      }
   }

   return (val);
}

   
   
   
//+------------------------------------------------------------------+
//| SHI Channels (by shimodax, based on shurka&kevin, based on slavic|
//+------------------------------------------------------------------+
int SHIChannels(int offset, int howmany, double &upslopehistobuf[], double &downslopehistobuf[], 
                           double &uplimitbuf[], double &medlimitbuf[], double &downlimitbuf[], double &pricealertbuf[], 
                           double &rcslope, int barsfofr, int lazyness)
{
   // by Shimodax, based on  "SHI_Channel.mq4 by Shurka & Kevin"
   // original link ""
   int currentbar= 0, startbar;
   double step=0, slope;
   int b1=-1, b2=-1;
   int updown=0, 
       barsforfract= 0; // fractal (reverse point) size
   double p1=0, p2=0, pp=0, px, llow, hhigh, p1lower, p1upper;
   int i=0, lastbar= 300, ishift=0, inspectwidth;
   double iprice=0;

   rcslope= 0;
   
   // lazyness (how many fresh bars will be ignored when determining the trend)
   if (lazyness<2)
      lazyness= 2;
   

	if ((howmany==0) || (Bars<offset+howmany)) 
	  lastbar= Bars; 
	else 
	  lastbar= offset+howmany;   //lastbar-  
	
	if (barsfofr>0) {
		barsforfract= barsfofr; 
   }
	else {
		switch (Period()) {
			case 1: barsforfract=12; break;
			case 5: barsforfract=48; break;
			case 15: barsforfract=24; break;
			case 30: barsforfract=24; break;
			case 60: barsforfract=12; break;
			case 240: barsforfract=15; break;
			case 1440: barsforfract=10; break;
			case 10080: barsforfract=6; break;
			default: return(-1); break;
		}
	}
	

	startbar= offset + lazyness;
	b1=-1; b2=-1; 
	updown=0;
	
	currentbar= startbar; 
	while(((b1==-1) || (b2==-1)) && (currentbar<lastbar))
	{
		//updown=1     , updown=-1   
		// , updown=0     .
		//1  2 -    ,     .
		//1  2 -       

      //UpDown=1 means the 1st fractal has been found on top,
      //UpDown=-1 means the 1st fractal has been found at the bottom,
      //UpDown=0 means a fractal has not yet been found
      //B1 & B2 - base line fractal bars
      //P1 & P2 - prices for this line
      
      
      inspectwidth= MathMax(currentbar-barsforfract, startbar);  // avoid negative indices (beyond zero-bar)
                                                                 // or looking further than startbar
                                                                 // (bug found by Shahin)
      
      llow= Lowest(NULL,0, MODE_LOW, barsforfract*2+1, inspectwidth);
		if(updown<1 && currentbar==llow) 
		{
			if(updown==0) { updown=-1; b1=currentbar; p1=Low[b1]; }
			else { b2=currentbar; p2=Low[b2];}
		}
		
		hhigh= Highest(NULL,0, MODE_HIGH, barsforfract*2+1, inspectwidth);
		if(updown>-1 && (currentbar==hhigh)) 
		{
			if(updown==0) { updown=1; b1=currentbar; p1=High[b1]; }
			else { b2=currentbar; p2=High[b2]; }
		}
		currentbar++;
	}

	if((b1==-1) || (b2==-1)) {
      if (DebugLogger)
        Print("No SHI channel at [", TimeOffset(lastbar), " ... ", TimeOffset(offset+2), "]");
  
      return(-1);    //      300  8-)
                     // No fractals have been found in 300 bar range 8-)
	}
	
	step= (p2-p1)/(b2-b1);                 // slope (price diff)/(time diff)
	                                       // (if positive then the channel is descending)
	                                       
	p1= p1-(b1-offset)*step; b1= offset;   // extend right side of channel up to the right side of 
	                                       // the requested area (usually end of chart, bar= 0)
	

   //
	// determine other sides channel border 
	//
	ishift=0; iprice=0;
	if(updown==1) { 
	
		pp= 99999; // too high to survive low-tests
		
		for (i= offset+lazyness; i<=b2; i++) {    // find lowest low matching slope
			pp= MathMin(pp, Low[i]-step*(i-offset)); 
		}
	
	   // swap to make pp upper and p1 lower Point
	   p1upper= p1;
	   p1lower= pp;
	} 
	else { 
		pp= -1; // too low to surive high tests
		
		for (i= offset+lazyness; i<=b2; i++) {    // find highest high matching slope
			pp= MathMax(pp, High[i]-step*(i-offset));
		}
		
	   p1upper= pp;
	   p1lower= p1;
	}

   // now the lower trend channel slopes back from b1/p1, the upper channel from b1/pp
   
   //
	// determine range braks (upper/lower channel)
	//
	for (i= 0; i<lazyness; i++) {
	  if (Low[offset+i]<p1lower+step*i) { 
	     ishift= offset+i; 
	     iprice= p1lower + step*i; 
	  }  
	  if (High[offset+i]>p1upper+step*i) { 
	     ishift= offset+1; 
	     iprice= p1upper + step*i; 
	   }
	}

   if (iprice!=0) 
      pricealertbuf[ishift]= iprice; // // 0 (zero) means the channel line remains intact, dot means the channel is broken
   
   

   //
   // fill buffers for the in-chart channel borders
   //
   for (i= lastbar; i>=offset; i--) {
      downlimitbuf[i]= p1lower + (step * (i-b1));
      medlimitbuf[i]= ((p1lower + p1upper)/2) + (step * (i-b1));
      uplimitbuf[i]= p1upper + (step * (i-b1));
   }



   //
   // fill buffers for use with the slope histogram
   //
   slope= -step/Point;


   //
   // fill in the slope into the slop buffers 
   // 

   if (slope>0) {
      upslopehistobuf[offset]= slope;
      downslopehistobuf[offset]= 0;
   }
   else {
      downslopehistobuf[offset]= slope;
      upslopehistobuf[offset]= 0;
   }
   
   /*
   for (i= offset; i<offset+lazyness+1; i++) {
      if (slope>0) 
         upslopehistobuf[i]= slope;
      else
         downslopehistobuf[i]= slope;
   }
   */

   rcslope= slope;
   
   if (DebugLogger)
      Print(TimeOffset(offset), "FXOE SHI channel at [", TimeOffset(lastbar), " ... ", TimeOffset(offset+1), "] is ", MathRound((pp-p1)/Point), " pips wide with slope ", slope);
	        
   return(0);
}



//+------------------------------------------------------------------+
//| Juice (std deviation limit) indicator by Shimodax, based on Perky|
//+------------------------------------------------------------------+
double Juice(int offset, int lastbar, double &upBuf[], double &downBuf[], int period= 7, int level= 4)
{
   // by Shimodax, based on  "Juice.mq4 by Perky"
   // original link "http://fxovereasy.atspace.com/index"
   double osma= 0;

   // if (JuicePeriod!=15)  
   //   Alert ("Juice Is Recommended for 15 Min Chart only!!");
   
   if (lastbar>Bars)
      lastbar= Bars;
      
   //---- main loop
   for(int i= lastbar; i>=offset; i--){
   
      upBuf[i]= 0;
      downBuf[i]=0;

      osma= iStdDev(NULL,0, period, MODE_EMA, 0, PRICE_CLOSE,i) - level*Point;
      
      if(osma>0)
         upBuf[i]= osma;
      else 
      if(osma<0)
         downBuf[i]= osma;
   }

   if (DebugLogger)
      Print(TimeOffset(offset), "FXOE-Juice is ", osma);

   return (osma); // return last computed value
}



//+------------------------------------------------------------------+
//| Custom indicator beef function                                   |
//+------------------------------------------------------------------+
double ITrend(int offset, int lastbar, double &value1[], double &value2[], double &histo1[], double &histo2[], int bperiod= 20, int bdevi= 2, int pperiod= 13)
{
   // by Shimodax, based on  "iTrend.mq4 by unknown"
   // original link "unknown"
   int i, bandsmode,
       Price_Type_0_3= 0;
   double powerprice,
          currentprice, 
          v1,
          v2,
          diff= 0;

   if (lastbar>Bars)
      lastbar= Bars;
      
   for (i= lastbar; i>=offset; i--) { 
   
      switch (Price_Type_0_3) {
         case 1: currentprice= Open[i]; break;
         case 2: currentprice= High[i]; break;
         case 3: currentprice= Low[i]; break;

         case 0:
         default: currentprice= Close[i]; break;
      }

      v1= currentprice - iBands(NULL,0, bperiod, bdevi, 0, bandsmode, powerprice, i);
      v2= -(iBearsPower(NULL,0, pperiod, powerprice,i) + iBullsPower(NULL,0,pperiod,powerprice,i)); 
      
      value1[i]= v1;
      value2[i]= v2;
      
      diff= v1 - v2; // green - red ..  don't use "value[offset] - value2[offset]" because array may be too small

      histo1[i]= 0;      
      histo2[i]= 0;
         
      if (diff>0)
         histo1[i]= diff;
      else
      if (diff<0)
         histo2[i]= diff;

   }  

   if (DebugLogger)
      Print(TimeOffset(offset), "FXOE-ITrend is ", diff);
      
   return(diff);  // last crossing (histogram)
}



//+------------------------------------------------------------------+
//| Laguerre filter on RSI (http://www.mesasoftware.com/TimeWarp.doc)|                                  |
//+------------------------------------------------------------------+
double LaguerreRSI(int offset, int lastbar, double &output[], double gamma)
{   
   // by Shimodax, based on  "Laguerre.mq4 by Emerald King"
   // original link "mailto:info@emerald-king.com"
   int i,
       swing_in= 70; // LRSI needs some swing-in/pre-heating to compute correct values
   double l0 = 0,
          l1 = 0,     
          l2 = 0,
          l3 = 0,
          l0a = 0,
          l1a = 0,
          l2a = 0,
          l3a = 0,
          lrsi = 0,
          cd = 0,
          cu = 0;
         
   if (lastbar>Bars)
      lastbar= Bars;
      
   for (i= lastbar+swing_in; i>=offset; i--) {

      l0a = l0;
      l1a = l1;
      l2a = l2;
      l3a = l3;
      
      l0 = (1 - gamma)*Close[i] + gamma*l0a;
      l1 = - gamma*l0 + l0a + gamma*l1a;
      l2 = - gamma*l1 + l1a + gamma*l2a;
      l3 = - gamma*l2 + l2a + gamma*l3a;

      cu = 0;
      cd = 0;
      
      if (l0 >= l1) cu = l0 - l1;      else cd = l1 - l0;
      if (l1 >= l2) cu = cu + l1 - l2; else cd = cd + l2 - l1;
      if (l2 >= l3) cu = cu + l2 - l3; else cd = cd + l3 - l2;

      if (cu + cd != 0) 
         lrsi = cu / (cu + cd);
         
      if (i<=lastbar)   // the first 150 iterations are just to swing in
         output[i] = lrsi;
	}

   if (DebugLogger)
      Print(TimeOffset(offset), "FXOE-LRSI is ", lrsi, " (gamma= ", DoubleToStr(gamma, 1), ")");

   return(lrsi);  // last result
}




//+------------------------------------------------------------------+
//| ASC-Trend Indicator (based on work by komposter                  |
//|                                     mailto:komposterius@mail.ru) |
//+------------------------------------------------------------------+
int AscTrend(int offset, int lastbar, double &signalslong[], double &signalsshort[], int risk)
{
   // by Shimodax, based on  "AscTrend1.mq4 by Komposter"
   // original link "mailto:komposterius@mail.ru"

   // see also:
   //  http://www.visualtradingcharts.com/forum/viewtopic.php?t=278
   //  http://www.wintick.com/6_0/hybrid_example.asp?M=Forex
   //  http://www.wintick.com/6_0/download/version6_0/manual.pdf


   #define STATE_LONG 1
   #define STATE_SHORT -1

   int i, n, 
         signal= 0,
         updown= 0, 
         rangedist= 10;
            
   double wprdefperiod= 10, 
          wprperiod,
          siglevelup=70,
          sigleveldown=30,
          avgrange, sum;
   
  
   wprdefperiod=  3+risk*2;
   siglevelup=    67+risk;    // used to be 70
   sigleveldown=  33-risk;    // used to be 30
   
   wprperiod= wprdefperiod;
   
   lastbar= MathMax(offset+250, lastbar);  // give it at least 250 bars to chew 
   lastbar= MathMin(Bars, lastbar);
      
   for (i= lastbar; i>=offset; i--) {

      avgrange= 0;
      sum= 0;

      signalslong[i]= 0;   // clear possibly old signals 
      signalsshort[i]= 0;  // (due to scrolling)
      
      for (n=i ;n<=i+(rangedist-1); n++) {
         sum= sum + MathAbs(High[n]-Low[n]);
      }
      avgrange= sum/rangedist;
      
      wprperiod= wprdefperiod;
      
      for (n= i; n<i+(rangedist-1); n++) {
         if (MathAbs(Open[n]-Close[n+1])>=avgrange*2.0 ) {
            wprperiod= 3; 
            break;
         }
      }

      for (n= i; n<i+(rangedist-1-3); n++) {
         if (MathAbs(Close[n]-Close[n+3])>=avgrange*4.6) {
            wprperiod= 4; 
            break;
         }
      }
      
		double wpr= iWPR(Symbol(), 0, wprperiod, i) + 100;     // convert [-100 ... 0] => [0 ... 100] 
      
      signal= 0;  // only used for function return value

		if (wpr>siglevelup && updown!=STATE_LONG) {            // upswing while not already long
		    signalslong[i]= High[i] - 2*Point; 
		    signal= STATE_LONG;
		    updown= STATE_LONG; 
		}

		if (wpr<sigleveldown && updown!=STATE_SHORT) {         // downswing while not already short
		    signalsshort[i]= Low[i] + 2*Point; 
		    signal= STATE_SHORT;
		    updown= STATE_SHORT; 
		}
   }

   if (DebugLogger)
      Print(TimeOffset(offset), "FXOE-ASCTREND is ", updown+signal);   
      
   return(updown + signal);
}


//+------------------------------------------------------------------+
//| Helper function                                                  |
//+------------------------------------------------------------------+
string TimeOffset(int offset) 
{
   string s= TimeToStr(Time[offset]) + " #" + offset + " ";
   return (s);
}