//|------------------------------------------------------------------+
//|                                                    SHI_Slope.mq4 |
//|                                         Shimodax, Shurka & Kevin |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Shimodax, based on SHI-Channel from Shurka & Kevin"
#property  link     "http://www.strategybuilderfx.com/forums/showthread.php?t=15112"

#property indicator_separate_window
#property indicator_buffers 2

#property indicator_color1 LimeGreen
#property indicator_color2 Red

double UpSlopeBuf[];
double DownSlopeBuf[];


//---- input parameters
extern bool AlertRedGreenChange= false;  // signal changes in slope 
extern int HistorySize= 1000;  // number of slope-values in history
extern int SHIBars= 240;      // bars to use to find a channel
extern int BarsForFract= 0;

#include "fxoe-lib.mqh"


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   //---- indicators

   SetIndexStyle(0, DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(0, UpSlopeBuf);
   SetIndexDrawBegin(0, Bars - HistorySize);
   
   SetIndexStyle(1, DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(1, DownSlopeBuf);
   SetIndexDrawBegin(1, Bars - HistorySize);
   
   IndicatorShortName("FXOE-Slope(Hist= "+HistorySize+" bars)= ");
	
   return(0);
}


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{

   return(0);
}



//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   double rcslope, dummy1[100], dummy2[100], dummy3[100], dummy4[100];
   int counted_bars= IndicatorCounted(),
       lastbar,
       rc;

   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars - counted_bars;
   lastbar= MathMin(lastbar, HistorySize-2);
   
   for (int i= lastbar; i>=0; i--) { 
      rc= SHIChannels(i, SHIBars, UpSlopeBuf, DownSlopeBuf, dummy1, dummy2, dummy3, dummy4, rcslope, BarsForFract, false);
      
      if (AlertRedGreenChange && i==0) {
         static bool didalert= false;

         double thisslope= UpSlopeBuf[0] + DownSlopeBuf[0],  // one of the two will be zero
                lastslope= UpSlopeBuf[1] + DownSlopeBuf[1];  // one of the two will be zero
      
         if ((thisslope>0 && lastslope<=0) || (thisslope<0 && lastslope>=0)) {
            if (!didalert) {
               Alert("FXOE-SHISlope signals change in channel direction on ", Symbol(),"/",Period());
               didalert= true;
            }
         }
         else {
            didalert= false;
         }  
      }
  }
   
   return (0);  
}
   


