//+------------------------------------------------------------------+
//|                                                    SHI_Slope.mq4 |
//|                                         Shimodax, Shurka & Kevin |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Shimodax, based on SHI-Channel from Shurka & Kevin"
#property  link     "http://www.strategybuilderfx.com/forums/showthread.php?t=15112"

#property indicator_chart_window
#property indicator_buffers 4

#property indicator_color1 Gold
#property indicator_color2 DarkGoldenrod
#property indicator_color3 Gold
#property indicator_color4 Red

double UpperLimitBuf[];
double MedLimitBuf[];
double LowerLimitBuf[];
double PriceAlertBuf[];


//---- input parameters
extern bool AlertSlopeChange= false;  // signal changes in slope 
extern bool AlertChannelBreak= false;  // signal changes in slope 
extern int SHIBars= 240;          // bars to use to find a channel
extern int BarsForFract= 0;

#include "fxoe-lib.mqh"




//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   //---- indicators

   SetIndexStyle(0, DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(0, UpperLimitBuf);
   SetIndexEmptyValue(0, 0.0);
   SetIndexLabel(0, "SHI Channel Upper");      
   
   SetIndexStyle(1, DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(1, MedLimitBuf);
   SetIndexEmptyValue(1, 0.0);
   SetIndexLabel(1, "SHI Channel Median");      
   
   SetIndexStyle(2, DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(2, LowerLimitBuf);
   SetIndexEmptyValue(2, 0.0);
   SetIndexLabel(2, "SHI Channel Lower");      
   
   SetIndexStyle(3,DRAW_ARROW);
   SetIndexArrow(3,164);
   SetIndexBuffer(3,PriceAlertBuf);
   SetIndexEmptyValue(3,0.0);
   
   IndicatorShortName("FXOE-SHI Channel("+SHIBars+" bars)");
	
   return(0);
}


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{

   return(0);
}



//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   static double lastslope= 0.0;
   static int didbreakalert= false;

   double rcslope, dummy1[100], dummy2[100];
   int counted_bars= IndicatorCounted(),
       rc;

   ArrayInitialize(UpperLimitBuf, 0.0);
   ArrayInitialize(MedLimitBuf, 0.0);
   ArrayInitialize(LowerLimitBuf, 0.0);
   ArrayInitialize(PriceAlertBuf, 0.0);
   
 
   rc= SHIChannels(0, SHIBars, dummy1, dummy2, UpperLimitBuf, MedLimitBuf, LowerLimitBuf, PriceAlertBuf, rcslope, BarsForFract, false);

   Comment(" SHI-Channel(", SHIBars, " bars): Channel Size= ", DoubleToStr(MathAbs(UpperLimitBuf[1] - LowerLimitBuf[1])/Point,0), ", Slope = ", DoubleToStr(rcslope, 2));
 
   if (AlertSlopeChange && rcslope!=lastslope) {
         Alert("FXOE-SHIChannel changed on ", Symbol(),"/",Period());
      lastslope= rcslope;
   }

   if (AlertChannelBreak && PriceAlertBuf[0]!=0) {
      if (!didbreakalert) {
         Alert("FXOE-SHIChannel signals break on ", Symbol(),"/",Period());
         didbreakalert= true;
      }
   }
   else {
      didbreakalert= false;
   }  
   
   return (0);  
}
   

