//+------------------------------------------------------------------+
//|                                                    SHI_Slope.mq4 |
//|                                          Shimodax & Emerald King |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Shimodax & Emerald King"
#property  link     "http://www.strategybuilderfx.com/forums/showthread.php?t=15112"

#property indicator_separate_window
#property indicator_color1 LightSeaGreen
#property indicator_level2 0.75
#property indicator_level3 0.45
#property indicator_level4 0.15

//---- input parameters
extern double Gamma= 0.7;

double LRSIBuf[];

#include "fxoe-lib.mqh"


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
      
int init()
{
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0, LRSIBuf);
   SetIndexDrawBegin(0,1);
   
   IndicatorShortName("FXOE-LaguerreRSI(Gamma= "+DoubleToStr(Gamma,1)+")= ");
   
   return(0);
}
  
int deinit()
{
   return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int counted_bars= IndicatorCounted(),
         lastbar;

      
   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars - counted_bars;
   
   LaguerreRSI(0, lastbar, LRSIBuf, Gamma);

   return (0);
}   



