//+------------------------------------------------------------------+
//|                                                   FXOE-Juice.mq4 |
//|                                               Shimodax & Perky_z |
//|                                                                  |
//+------------------------------------------------------------------+
#property  copyright "Shimodax, base on work by Perky"
#property  link      "http://www.strategybuilderfx.com/forums/showthread.php?t=15112"

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 2
#property  indicator_color1  LimeGreen
#property  indicator_color2  Red

//---- indicator parameters
extern int JuicePeriod= 7;
extern int Level= 4;

//---- indicator Bufs
double OsMAUpBuf[];
double OsMADownBuf[];

#include "fxoe-lib.mqh"



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   //---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,1);
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,1);
   SetIndexDrawBegin(0,Level*Point);
   SetIndexDrawBegin(1,Level*Point);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+2);
   
   //---- 2 indicator Bufs mapping
   if(!SetIndexBuffer(0,OsMAUpBuf) && !SetIndexBuffer(1,OsMADownBuf)) {
      Print("cannot set indicator Bufs!");
   }
      
   //---- name for DataWindow and indicator subwindow label
   IndicatorShortName("FXOE-Juice(Period= "+JuicePeriod+", Level= "+Level+" pips)= ");
   
   //---- initialization done
   return(0);
}


//+------------------------------------------------------------------+
//| Moving Average of Oscillator                                     |
//+------------------------------------------------------------------+
int start()
{
   int counted_bars= IndicatorCounted(),
         start;

   if (Bars<=JuicePeriod) 
      return(0);
      
   if (counted_bars>0)
      counted_bars--;
      
   start= Bars - counted_bars;

   Juice(0, start, OsMAUpBuf, OsMADownBuf, JuicePeriod, Level);

   //---- done
   return(0);
}


