//+------------------------------------------------------------------+
//|                                                       iTrend.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "unknown"
#property link      "unknown"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 LimeGreen
#property indicator_color2 Red

//---- input parameters
extern int Bands_Period=    20;
extern int Bands_Deviation= 2;
extern int Power_Period=    13;

       int Bands_Mode_0_2=  0;  // =0-2 MODE_MAIN, MODE_LOW, MODE_HIGH
       int Power_Price_0_6= 0;  // =0-6 PRICE_CLOSE,PRICE_OPEN,PRICE_HIGH,PRICE_LOW,PRICE_MEDIAN,PRICE_TYPICAL,PRICE_WEIGHTED
       int Price_Type_0_3=  0;  // =0-3 PRICE_CLOSE,PRICE_OPEN,PRICE_HIGH,PRICE_LOW


//---- buffers
double TrendBuf1[];
double TrendBuf2[];

#include "fxoe-lib.mqh"


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   //   string short_name;
   //---- indicator line
   IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,TrendBuf1);
   SetIndexDrawBegin(0, Bands_Period+1);

   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,TrendBuf2);
   SetIndexDrawBegin(1, Bands_Period+1);

   IndicatorShortName("FXOE-ITrendHistogram(" + Bands_Period + ", " + Bands_Deviation + ", " + Power_Period + ")= ");
   
   //----
   return(0);
}


//+------------------------------------------------------------------+
//| Trend                                                            |
//+------------------------------------------------------------------+
int start()
{
   double dummy1[], dummy2[];
   int counted_bars= IndicatorCounted(),
         lastbar;

   if (Bars<=Bands_Period) 
      return(0);
      
   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars - counted_bars;

   ITrend(0, lastbar, dummy1, dummy2, TrendBuf1, TrendBuf2, Bands_Period, Bands_Deviation, Power_Period);
   
   return (0);
}


