//+------------------------------------------------------------------+
//|                                                  FXOE-ITrend.mq4 |
//|                                                         Shimodax |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Shimodax, based on work by unknown author"
#property  link      "http://www.strategybuilderfx.com/forums/showthread.php?t=15112"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 LimeGreen
#property indicator_color2 Red

//---- input parameters
extern int Bands_Period=    20;
extern int Bands_Deviation= 2;
extern int Power_Period=    13;

       int Bands_Mode_0_2=  0;  // =0-2 MODE_MAIN, MODE_LOW, MODE_HIGH
       int Power_Price_0_6= 0;  // =0-6 PRICE_CLOSE,PRICE_OPEN,PRICE_HIGH,PRICE_LOW,PRICE_MEDIAN,PRICE_TYPICAL,PRICE_WEIGHTED
       int Price_Type_0_3=  0;  // =0-3 PRICE_CLOSE,PRICE_OPEN,PRICE_HIGH,PRICE_LOW


//---- buffers
double TrendBuf1[];
double TrendBuf2[];

#include "fxoe-lib.mqh"


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   //   string short_name;
   //---- indicator line
   IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,TrendBuf1);
   SetIndexDrawBegin(0, Bands_Period+1);

   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,TrendBuf2);
   SetIndexDrawBegin(1, Bands_Period+1);

   IndicatorShortName("FXOE-ITrend(" + Bands_Period + ", " + Bands_Deviation + ", " + Power_Period + ")= ");


   //----
   return(0);
}


//+------------------------------------------------------------------+
//| Trend                                                            |
//+------------------------------------------------------------------+
int start()
{
   double dummy1[], dummy2[];
   int counted_bars= IndicatorCounted(),
         lastbar;

   if (Bars<=Bands_Period) 
      return(0);
      
   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars - counted_bars;

   ITrend(0, lastbar, TrendBuf1, TrendBuf2, dummy1, dummy2, Bands_Period, Bands_Deviation, Power_Period);
   
   return (0);
}


//+------------------------------------------------------------------+
//| Custom indicator beef function                                   |
//+------------------------------------------------------------------+

/*
double iTrend(int offset, int lastbar, double &value[], double &value2[], int bperiod= 20, int bdevi= 2, int pperiod= 13);
{
   int i, bandsmode;
   double powerprice,
          currentprice, 
          diff= 0;

   /+ the following is useless, the values mean this anyway, i.e. MODE_MAIN is zero, etc. 
   if (Bands_Mode_0_2==0) bandsmode=MODE_MAIN;
   if (Bands_Mode_0_2==1) bandsmode=MODE_LOW;
   if (Bands_Mode_0_2==2) bandsmode=MODE_HIGH;

   if (Power_Price_0_6==0) powerprice=PRICE_CLOSE;
   if (Power_Price_0_6==1) powerprice=PRICE_OPEN;
   if (Power_Price_0_6==2) powerprice=PRICE_HIGH;
   if (Power_Price_0_6==3) powerprice=PRICE_LOW;
   if (Power_Price_0_6==4) powerprice=PRICE_MEDIAN;
   if (Power_Price_0_6==5) powerprice=PRICE_TYPICAL;
   if (Power_Price_0_6==6) powerprice=PRICE_WEIGHTED;
   +/

   if (lastbar>Bars)
      lastbar= Bars;
      
   for (i= lastbar; i>=offset; i--) { 
   
      switch (Price_Type_0_3) {
         case 1: currentprice= Open[i]; break;
         case 2: currentprice= High[i]; break;
         case 3: currentprice= Low[i]; break;

         case 0:
         default: currentprice= Close[i]; break;
      }

      value[i]= currentprice - iBands(NULL,0, bperiod, bdevi, 0, bandsmode, powerprice, i);
      value2[i]= -(iBearsPower(NULL,0, pperiod, powerprice,i)+ iBullsPower(NULL,0,pperiod,powerprice,i)); 
      
      diff= value[offset]-value2[offset];   // green - red
   }  

   return(diff);  // last crossing (histogram)
}
*/ 

//+------------------------------------------------------------------+