//+------------------------------------------------------------------+
//|                                                   FXOE.COmbo.mq4 |
//|                                                         Shimodax |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Shimodax"
#property  link     "http://www.strategybuilderfx.com/forums/showthread.php?t=15112"


#property indicator_separate_window

#property indicator_buffers 3
#property indicator_color1 Gray
#property indicator_color2 OrangeRed
#property indicator_color3 LawnGreen

#property indicator_maximum 8
#property indicator_minimum -8

#property indicator_level1 6
#property indicator_level2 -6

//---- buffers
extern int HistorySize= 1000;
extern bool UseAscTrend= 1;
extern int ColorThreshold= 6;
extern int AlertThreshold= 8;
extern int LRSI_Echo= 3;
extern double LRSI_Gamma= 0.7;
extern int JuiceLevel= 4;

#include "fxoe-lib.mqh"

double Long2SignalBuffer[],
       Short2SignalBuffer[],
       LongSignalBuffer[],
       ShortSignalBuffer[],
       NeutralBuffer[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(0,NeutralBuffer);
   SetIndexEmptyValue(0, 0.0);

   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(1,ShortSignalBuffer);
   SetIndexEmptyValue(1, 0.0);

   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(2,LongSignalBuffer);
   SetIndexEmptyValue(2, 0.0);

   string asctrend= "on", alert= "on/" + AlertThreshold;
   if (!UseAscTrend)
      asctrend= "off";
      
   if (AlertThreshold==0) 
      alert= "off";
      
   IndicatorShortName("FXOE-Combo(AscTrend= " + asctrend + ", Alert= " + alert + ", Gamma= " + DoubleToStr(LRSI_Gamma,1) + ")= ");

   return(0);
}



int start()
{
   static bool didalert= false;
   int counted_bars= IndicatorCounted(),
         lastbar, result;

   if (Bars<=100) 
      return(0);
      
   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars - counted_bars;
   lastbar= MathMin(HistorySize, lastbar);

   result= Combo(0, lastbar, LongSignalBuffer, ShortSignalBuffer, NeutralBuffer, 
                     UseAscTrend, LRSI_Gamma, LRSI_Echo, JuiceLevel, ColorThreshold);
                     
   if (AlertThreshold>0 && MathAbs(result)>=AlertThreshold) {
      if (!didalert) {
         Alert("FXOverEasy signals trade on ", Symbol(),"/",Period());
         didalert= true;
      }
   }
   else {
      didalert= false;
   }  
    
   return (0);
}


