//+------------------------------------------------------------------+
//|                                                FXOE-ASCtrend.mq4 |
//|                  Shimodax, based on work by Komposter and others |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Shimodax, based on work by Komposter and others"
#property  link     "http://www.strategybuilderfx.com/forums/showthread.php?t=15112"

/* see also:
http://www.visualtradingcharts.com/forum/viewtopic.php?t=278
http://www.wintick.com/6_0/hybrid_example.asp?M=Forex
http://www.wintick.com/6_0/download/version6_0/manual.pdf
*/

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Aqua
#property indicator_color2 Magenta

extern bool Alerts= false;
extern int HistorySize= 1000;
extern int Risk= 4;

#include "fxoe-lib.mqh"

double BuyBuffer[];
double SellBuffer[];



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   //---- indicators
   SetIndexStyle(0,DRAW_ARROW,EMPTY);
   SetIndexArrow(0,164);
   SetIndexBuffer(0, BuyBuffer);

   SetIndexStyle(1,DRAW_ARROW,EMPTY);
   SetIndexArrow(1,164);
   SetIndexBuffer(1, SellBuffer);
   
   IndicatorShortName("FXOE-AscTrend(Risk= "+Risk+")= ");
   
   return(0);
}


//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   return(0);
}
   
   
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{   
   static double lastsignal= 0.0;   
   double signal;
   int counted_bars= IndicatorCounted(),
         lastbar;

   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars-counted_bars;
   lastbar= MathMin(HistorySize, lastbar);
 
   AscTrend(0, lastbar, BuyBuffer, SellBuffer, Risk);

   if (BuyBuffer[0]!=0) 
      signal= +1;
   else 
   if (SellBuffer[0]!=0)  
      signal= -1;
   else 
      signal= 0; 

   if (Alerts && signal!=0) {

      if (signal!=lastsignal) {
         Alert("FXOE-AscTrend signal on ", Symbol(),"/",Period());
         lastsignal= signal;   
      }
   }
   else {
      lastsignal= 0;
   }
   
 
   return (0);
}


